# Running Multiple Tools in One Go

From version 0.2.87+, ToolMate AI supports use of multiple tools in a single request. It enables individual tools to work on results, generated by running previous tools. With this distinctive feature, users can have a full control of the content generation or task execution in each single step.

![multiple_tools_in_single_prompt](https://github.com/user-attachments/assets/7bdc63cd-beca-44c9-bfb0-27596a5e0632)

# How to use?

You can place multiple-step actions in a single prompt.  Begin each step or action with a declaration that starts with `@` to specify the tool to be applied for the step.

At the time of writing, available tools are:

@add_google_calendar_event @add_outlook_calendar_event @agents @append_command @append_fabric @append_instruction @apps @b @bapi @bible @bible_commentary @captain @chat @chatgpt @codey @command @convert_relative_datetime @copy_to_clipboard @correct_python_code @create_image_dalle3 @create_image_imagen3 @create_map @create_qrcode @create_statistical_graphics @datetimes @deep_reflection @download_web_content @download_youtube_audio @download_youtube_video @edit_text @examine_audio_google @examine_audio_groq @examine_audio_openai @examine_audio_whisper @examine_files @examine_images_chatgpt @examine_images_googleai @examine_images_groq @examine_images_llamacpp @examine_images_ollama @examine_images_pixtral @examine_images_vertexai @examine_web_content @execute_python_code @extract_bible_references @extract_python_code @fabric @files @general @googleai @groq @group @help @images @improve_writing @install_python_package @it @list_current_directory_contents @llamacpppython @llamacppserver @load_conversations @lyrics @map @mistral @modify_images @music @news @o1 @o1_mini @ollama @online @open_browser @packages @palm2 @paste_from_clipboard @perplexica_chatgpt @perplexica_googleai @perplexica_groq @perplexica_xai @proxy @qna @radio @read_aloud @recommend_tool @reflection @remove_image_background @repos @save_memory @science @scientific_publications @search_bible @search_bible_paragraphs @search_conversations @search_finance @search_google @search_google_news @search_memory @search_searxng @search_sqlite @search_tavily @search_weather @send_gmail @send_outlook @send_tweet @social_media @software_wikis @task @tavily @transcribe_audio_google @transcribe_audio_groq @transcribe_audio_openai @transcribe_audio_whisper @translate @uniquebible @uniquebible_api @uniquebible_web @vertexai @videos @web @wikimedia @workflow @xai

Android-only tools:

@show_location @show_connection @start_recording @stop_recording @phone_call @play_media @search_contacts @take_photo @selfie @read_sms @send_sms @send_email @send_whatsapp @share @share_file

Remarks:

* Enter `@` to read brief descriptions of all available tools
* Enter `@`, followed by a space character, to get input suggestions of all available tools
* `@chat` represents the chat tool that retrieves a direct response from the chosen LLM
* `@command` Execute the given command
* `@append_command` Append assistant previous response to the given command and execute
* Tool declaration have to be followed by a space character or a linebreak.  For example, `@chat` have to be followed by a space character or a linebreak. (You may use `TAB` to quickly enter a linebreak.  Alternately, you may enter `.togglemultiline` to toggle multi-line support.)
* Enable / Disable available plugins to make more / less tools available
* When no tool is specified, the prompt is treated as a single input as usual. In such cases, ToolMate AI will decide the use of tools based on your `tool dependence` settings.

# Work on Generated Response from Previous Tool

Basically, using multiple tools in a single prompt is like a workflow that enables users requests to be processed by a chain of tools in order. Generated response in each step is further processed by the next tool. In the following example, the second step will generate a summary on the generated content resulted from the first step.

```
@chat What is machine learning?
@chat Give me a summary.
```

In addition, you may append a prompt description with the previous generated response. Tools, such as `@append_instruction`, `@append_command` and `@append_fabric`, are created for such purpose. In the following example, the words `Machine Learning` generated in the first step complete the second prompt, i.e. `Describe Machine Learning`.

```
@command echo "Machine Learning"
@append_instruction Describe
```

Furthermore, you may also specify a tool without giving any description.

In the following example, `@download_youtube_audio` is given without any description following it.  In this case, the tool `@download_youtube_audio` works on the generated response in the previous step, i.e. `@chat Give me a random Youtube link`.

```
@chat Give me a random Youtube link 
@download_youtube_audio
```

To show a difference, the following example copy the word `World`:

```
@command echo Hello
@copy_to_clipboard World
```

However, the following example copy the word `Hello`:

```
@command echo Hello
@copy_to_clipboard
```

The only exceptions to the last rule are `@paste_from_clipboard` and `@list_current_directory_contents`. `@paste_from_clipboard` retrieves the text from clipboard no description is provided. If `@paste_from_clipboard` is followed by a description, the clipboard text will append to the description for generating a chat response. `@list_current_directory_contents` lists current directory contents regardless of the description following it.
 
# Examples of Use Cases

## Guided Step-by-step Responses for Detailed Research

To guide your chosen LLM to provide you with a step-by-step response, for example:

```
@chat What is narrative therapy? 
@chat How does it compare to other popular counselling approaches? 
@chat Tell me pros and cons of this approach? 
@chat Give me theories that support this approach in detail. 
@chat Any controversies about it? 
@chat Give me a summary of all your findings above.
```

## Multiple Computing Tasks in Order

To guide ToolMate AI to perform multiple computing tasks in order.

For example, download two more songs from Youtube and play all downloaded mp3 files with VLC player:

```
@download_youtube_audio https://youtu.be/KBD18rsVJHk?si=PhfzNCOBIj7o_Bdy 
@download_youtube_audio https://www.youtube.com/watch?v=gCGs6t3tOCU
@task Play the all mp3 files in folder `/home/ubuntu/toolmate/audio` with command `vlc`
```

## Tool and Chat Feature Integration

To integrate multiple tools and chat features in a single prompt, for example:

```
@search_google Latest updates about OpenAI in 2024 
@chat Give me a summary 
@send_gmail Email your findings to support@letmedoit.ai in detail
```

## Multiple Model Collaboration

Enable plugins `ask_chatgpt`, `ask_codey`, `ask_gemini`, `ask_groq`, `ask_llama3_1`, `ask_llamacpp`, `ask_llamacppserver`, `ask_ollama`, `ask_palm2`, you can do something like:

```
@chat What is the future of AI development?
chatgpt What is your opinion?
gemini What do you disagree?
```

or

```
llama3_1 Write code to extract mp3 audio from Youtube video
codey Review the code generated above
```

## System Command Integration

From Version: 0.2.90

1. Added two new tools:

`@command` Execute the given command

`@append_command` Append assistant previous response to the given command and execute.

```
@command echo "Hello World!"
@append_command echo
```

These new tools work with multiple tools in a single prompt.

For an example, to integrate `fabric` with other ToolMate AI tools, you may do something like this:

```
@command /home/ubuntu/go/bin/fabric -m gemini-1.5-pro -p write_essay "What is machine learning?"
@append_command /home/ubuntu/go/bin/fabric -m llama3.1:latest -p extract_wisdom
@append_command /home/ubuntu/go/bin/fabric -m mistral-large:123b -p summarize
gemini Explain it to a five-year kid
chatgpt Translate it into Chinese
```

# Read More

system command integration at https://github.com/eliranwong/toolmate/blob/main/package/toolmate/docs/System%20Command%20Integration.md

fabric integration at https://github.com/eliranwong/toolmate/blob/main/package/toolmate/docs/Fabric%20Integration.md